(function ($) {
    // Descripcion: Este plugin acomoda el texto SVG en lineas <tspan> de acuerdo a la cantidad de caracteres y su limite. 
    // los datas- a modificar en el HTML son:
    // data - font = "tamaño de fuente"
    // data - limite = "numero de caracteres"
    // data - alinear = "start | middle | end" >>> justificaion del texto
    // data - medial = "[1|2|3]" >>> 1. fisico 2. internet 3. fisico y internet
    // data - obtenido = "[1|0]" >>> 1. ya lo tiene 0. no lo tiene aun.
    // Autor: Carlos Galiano
    
    //la intencion es que por libro se modifique cuando se cree la obra:
    //<g class="titulo_obra" data-font="40" data-limite="11" data-alinear="start" data-medial="1" data-obtenido="1">Código Civil</g>
    

    function cortar(textoActualDividido, limite) {
        var bloques = [];
        var bloquesDeVuelta = [];
        var deVuelta = "";
        var resto = [];
        var unir = textoActualDividido.join(" ");
        limite = parseInt(limite);
        var cortar = "";
        cortar = unir.slice(0, limite);
        var enBlanco = cortar.lastIndexOf(" ");
        if (unir.length !== cortar.length) {
            if (cortar.lastIndexOf(" ") !== -1) {
                deVuelta = cortar.slice(0, enBlanco);
                bloquesDeVuelta.push(deVuelta);
                if (resto[0] !== "") {
                    resto = unir.slice(enBlanco + 1, unir.length + 1).split(" ");
                } else {
                    resto = unir.slice(enBlanco, unir.length + 1).split(" ");
                }
            } else {
                var primerEspacio = unir.indexOf(" ");
                deVuelta = unir.slice(0, primerEspacio);
                bloquesDeVuelta.push(deVuelta);
                if (resto[0] !== "") {
                    resto = unir.slice(primerEspacio + 1, unir.length + 1).split(" ");
                } else {
                    resto = unir.slice(primerEspacio, unir.length + 1).split(" ");
                }
            }
        } else {
            deVuelta = unir;
            bloquesDeVuelta.push(deVuelta);
            resto = [""];
        }
        if (deVuelta == "") {
            bloques = resto;
        } else {
            bloques.push(bloquesDeVuelta);
            bloques.push(resto);
        }
        return bloques;
    }




    $.fn.librosLegis = function (opcion) {
        $.fn.librosLegis.variables = {
            class_svg_titulo_obra: 'titulo_obra',
            class_svg_titulo: 'colocarTextSVG'            
        }
        opcion = $.extend({}, $.fn.librosLegis.variables, opcion);
        this.each(function () {
            var libroSVG = $(this);
            var arrayTitulo;
            var texto = libroSVG.find("." + opcion.class_svg_titulo_obra).text().split(" ");
            var fontSize = libroSVG.find("." + opcion.class_svg_titulo_obra).data("font");
            var limite = libroSVG.find("." + opcion.class_svg_titulo_obra).data("limite");
            var alinear = libroSVG.find("." + opcion.class_svg_titulo_obra).data("alinear");
            
            var bloqueAsegurado = [];
            var estructurado = [];

            
            function medio(tipo) {
                switch (tipo) {
                    case 1:
                        libroSVG.find(".medial-fisico").css("display", "block");
                        libroSVG.find(".soloInternet").css("display", "block");
                        break;
                    case 2:
                        libroSVG.find(".medial-internet").css("display", "block" );
                        libroSVG.find(".medial-internet").attr({
                            "transform": "translate(0, 50)",
                            "transform": "scale(1.6, 1.6)"
                        });
                        //  "transform": "translate(0, 50)",
                        //  "transform": "scale(1.6, 1.6)"
                        
                        break;
                    case 3:
                        libroSVG.find(".medial-fisico").css("display", "block");
                        libroSVG.find(".medial-internet").css("display", "block");
                        libroSVG.find(".soloInternet").css("display", "block");
                        break;
                    default:
                        break;
                }
            }
            function obtenido(estado) {
                if (estado != 0){
                    libroSVG.find(".obtenido").css("display", "block");
                }
            }
            medio(libroSVG.find("." + opcion.class_svg_titulo_obra).data("medial"));
            obtenido(libroSVG.find("." + opcion.class_svg_titulo_obra).data("obtenido"));
            

            function proceso(texto, limite) {
                var nuevoText = [];
                nuevoText.length = 0;
                estructurado = cortar(texto, limite);
                bloqueAsegurado.push(estructurado[0]);
                var bloqueResto = estructurado[1];
                if (bloqueResto.length > 1) {
                    proceso(bloqueResto, limite);
                } else {
                    bloqueAsegurado.push(bloqueResto[0].split());
                }
                return bloqueAsegurado;
            }

            libroSVG.find("." + opcion.class_svg_titulo).attr('font-size', fontSize + 'pt');
            estructurado = proceso(texto, limite);
            var arrayTitulo = estructurado;
            var unPoco = fontSize + 5;
            var pushPalabra = [];
            var posicion_x = 0;
            switch (alinear) {
                case "start":
                    posicion_x = "0";
                    break;
                case "middle":
                    posicion_x = "165";
                    break;
                case "end":
                    posicion_x = "331";
                    break;
                default:
                    break;
            }
            for (x = 0; x < arrayTitulo.length; x++) {
                if (x == 0) {
                    pushPalabra.push('<tspan text-anchor="' + alinear + '" x="' + posicion_x + '" dy="0">' + arrayTitulo[x] + '</tspan>');
                    continue;
                }
                //alignment-baseline="text-before-edge"
                pushPalabra.push('<tspan text-anchor="' + alinear + '" x="' + posicion_x + '" dy="' + unPoco + 'pt">' + arrayTitulo[x] + '</tspan>');
            }
            var palabra = pushPalabra.join('');
            for (var v = 0; v < libroSVG.length; v++) {
                libroSVG.find("." + opcion.class_svg_titulo).html(palabra);
            }
        });
        return this;
    }
})(jQuery);